

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float		LOD_firstLevel;
float		LOD_nextLevel;
float		LOD_changePoint;

float3		eyePosition;
float2		sectionPosition;
float		waterHeight;
float4		waterColour;

///////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float2	position	:	TEXCOORD0;
	float2	uv			:	TEXCOORD1;
	float	height		:	TEXCOORD2;
	float	nextHeight	:	TEXCOORD3;
};
	
///////////////////////////////////////////////////////////

struct VS_OUTPUT 
{
	float4	position		:	POSITION;
	float2	uv				:	TEXCOORD0;
	float	height			:	TEXCOORD1;
};

///////////////////////////////////////////////////////////

VS_OUTPUT vs_terrain_underwater_mid( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = float4(input.position.x + sectionPosition.x,input.height,input.position.y + sectionPosition.y,1);
	
	float nLodDistance = sqrt((eyePosition.x-output.position.x)*(eyePosition.x-output.position.x) + (eyePosition.y-output.position.y)*(eyePosition.y-output.position.y) + (eyePosition.z-output.position.z)*(eyePosition.z-output.position.z));
	if (nLodDistance >= LOD_changePoint)
		output.position.y = lerp( input.height, input.nextHeight, clamp((nLodDistance - LOD_changePoint) / ((LOD_nextLevel - LOD_firstLevel) * 0.25f),0,1) );

	output.height = output.position.y;
	
	output.position = mul(output.position, shader_transform_viewProj);
	output.uv = input.uv;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_4 = sampler_state
{
	Texture = (shader_texture_3);
	MipFilter=Linear;
	AddressU=Clamp;
	AddressV=Clamp;
};

////////////////////////////////////////////////////////////

float4 ps_terrain_underwater_mid( VS_OUTPUT input ) : COLOR0
{
	// lerp to underwater colour

	float nUnderWaterMult = saturate((waterHeight-input.height) / 250.0f);

	return float4(lerp(tex2D(sampler_colour_4, input.uv ).rgb, waterColour.rgb, nUnderWaterMult),1);
}


technique terrain_underwater_mid_11_20
{
	pass P0
	{
		AlphaBlendEnable = False;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_terrain_underwater_mid();	
		PixelShader = compile ps_2_0 ps_terrain_underwater_mid();	
	}
}

technique terrain_underwater_mid_11_00
{
	pass P0
	{
	}
}